#include <stdio.h>
#include <stdlib.h>

struct item
{
	int data;
	struct item *next;
};

void push(struct item **phead, int a)
{
	struct item *p = malloc(sizeof(*p));
	p->data = a;
	p->next = *phead;
	*phead = p;
}

void print(struct item *head)
{
	struct item *p;
	for (p = head; p; p = p->next)
	{
		printf("%d ", p->data);
	}
	printf("\n");
}

void pop(struct item **phead)
{
	struct item *q = (*phead)->next;
	free(*phead);
	*phead = q;
}

int empty(struct item *head)
{
	return (head == NULL);
}

void insert_last(struct item **phead, int a)
/*       
 *     
 */
{
	struct item *p = *phead;
	if (!*phead)
	{
		push(phead, a);
		return;
	}
	while (p->next)
	{
		p = p->next;
	}
	push(&(p->next), a);
}

int main()
{
	struct item *head = NULL;
	int a;

	while (scanf("%d", &a) == 1)
	{
		insert_last(&head, a);
	}

	print(head);

	while (!empty(head))
	{
		pop(&head);
	}

	return 0;
}
