#include <stdio.h>
#include <stdarg.h>

void printstr(char *s)
{
	while (*s)
	{
		putchar(*s);
		s++;
	}
}

void printint(int a)
{
	if (a < 0) 
	{
		putchar('-');
		printint(-a);
		return;
	}
	if (a < 10)
	{
		putchar(a + '0');
		return;
	}
	printint(a / 10);
	putchar((a % 10) + '0');
}

void myprintf(char *fmt, ...)
{
	va_list vl;
	va_start(vl, fmt);
	while (*fmt)
	{
		if (*fmt == '%')
		{
			fmt++;
			if (*fmt == '%') putchar('%');
			else if (*fmt == 'c') putchar(va_arg(vl, int));
			else if (*fmt == 'd') printint(va_arg(vl, int));
			else if (*fmt == 's') printstr(va_arg(vl, char *));
			else printstr("!!!");
			
			if (*fmt == 0)
				break;
		}
		else
		{
			putchar(*fmt);
		}
		fmt++;
	}

	va_end(vl);
}

int main()
{
	myprintf("a%%bc%dzz%d\n%", 42); 
	return 0;
}
